-- moonIcons: the return of dubaiOne's custom OptionsIcons.

local Player = ...;
assert(Player, "moonIcons requires a player.");
local pname = pname(Player);
--------------------------------------------------------------------------------
--[[ configuration ]]
local spacingX = 47; -- should really be width of icon - 1
local spacingY = -16; -- this means they go up, this should be configurable easier.

local numRows = 1;
local numCols = 6;
--------------------------------------------------------------------------------

local c;
-- make the ActorFrame to store the icons.
local u = Def.ActorFrame{
	Name="OptionIconRow"..pname;
	OnCommand=cmd(playcommand,"Update");
	UpdateCommand=function(self)
		-- get the options.
		local PlayerState = GAMESTATE:GetPlayerState(Player);
		-- grab the song options from this PlayerState.
		local options = PlayerState:GetPlayerOptionsString('ModsLevel_Preferred');
		-- now using split, let's put them into a table for comparison
		local listOfOptions = split(", ", options);
		-- find out how many options are in play.
		local numOptions = #listOfOptions;

		-- right now, let's keep it simple and to one line.
		local iconMain, iconImage, iconText;
		for row=1,numRows do
			for i=1,numCols do
				iconMain = self:GetChild( pname.."ModIcon"..i );
				iconImage = iconMain:GetChild("Icon");
				iconText = iconMain:GetChild("Label");

				local text = listOfOptions[i] or "";
				iconText:settext(text);
				if text == "" then
					iconImage:diffuse( color("1,1,1,1") );
				else
					iconImage:diffuse( PlayerColor(Player) );
				end;
				iconImage:diffusealpha(0.75);
			end;
		end;
	end;
	PlayerOptionsChangedMessageCommand=function(self,param)
		if param.PlayerNumber == Player then
			self:playcommand("Update");
		end;
	end;
};

local function MakeIcons()
	for i=1,numCols do
		u[#u+1] = Def.ActorFrame{
			Name=pname.."ModIcon"..i;
			-- xxx: should determine spacing some other way
			-- for multiple rows
			InitCommand=cmd(x,((i-1) * spacingX);y,0;diffusealpha,0.8);

			LoadActor("_optionicon")..{
				Name="Icon";
			};
			AutoText("frutiger",true)..{
				Name="Label";
				Text="";
				InitCommand=cmd(zoom,0.5;diffuse,color("#FFFFFF");NoStroke;shadowlength,1;maxwidth,90);
			};
		};
	end;
end;

u.InitCommand=MakeIcons();

return u;

--[[
Copyright  2008-2012 AJ Kelly
All rights reserved.

This code is licensed under AJ's StepMania Theme License.

Terms of the license are as follows:
1) Redistributions of this code must include this license.

2) Under this license, you agree to not claim the theme as your own or
use parts of it without permission. Please contact me if you wish to use this
code in your own themes.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--]]